implementation module timerdefaccess


import	StdBool, StdMisc
import	StdMaybe, StdTimerDef
import	commondef


timerDefGetAttributes :: !(Timer t .ls .ps) -> (Maybe Id, SelectState, TimerInterval, TimerFunction *(.ls,.ps))
timerDefGetAttributes (Timer interval items atts)
	=	(optId, select, interval, f)
where
	(optId, select, f)	= getAttributes atts
	
	getAttributes :: ![TimerAttribute .ps] -> (Maybe Id, SelectState, TimerFunction .ps)
	getAttributes atts
		=	(if hasId (Just (getId id)) Nothing, getSelect select, getFun f)
	where
		(hasId,id)	= Select istimerid			defId	atts
		(_,select)	= Select istimerselectstate	defSel	atts
		(_,f)		= Select istimerfunction	defFun	atts
		
		defId		= TimerId			undef
		defSel		= TimerSelectState	Able
		defFun		= TimerFunction		K`
		
		getId		(TimerId			id)		= id
		getSelect	(TimerSelectState	select)	= select
		getFun		(TimerFunction		f)		= f

timerDefGetElements :: !(Timer t .ls .ps) -> t .ls .ps
timerDefGetElements (Timer _ items _)
	=	items

timerDefSetAbility	:: !(Timer t .ls .ps) !SelectState -> Timer t .ls .ps
timerDefSetAbility (Timer interval items atts) select
	=	Timer interval items (setAbility select atts)
where
	setAbility :: !SelectState ![TimerAttribute .ps] -> [TimerAttribute .ps]
	setAbility select atts
		|	done
			= atts1
		|	otherwise
			= [att:atts]
	where
		att			= TimerSelectState select
		(done,atts1)= Replace istimerselectstate att atts

timerDefSetInterval	:: !(Timer t .ls .ps) !TimerInterval -> Timer t .ls .ps
timerDefSetInterval (Timer _ items atts) interval
	=	Timer interval items atts

timerDefSetFunction	:: !(Timer t .ls .ps) !(TimerFunction *(.ls,.ps)) -> Timer t .ls .ps
timerDefSetFunction (Timer interval items atts) f
	=	Timer interval items (setFunction f atts)
where
	setFunction :: !(TimerFunction .ps) ![TimerAttribute .ps] -> [TimerAttribute .ps]
	setFunction f atts
		|	done
			= atts1
		|	otherwise
			= [att:atts]
	where
		att			= TimerFunction f
		(done,atts1)= Replace istimerfunction att atts


istimerid			:: !(TimerAttribute .ps) -> Bool
istimerid			(TimerId _)				= True
istimerid			_						= False

istimerselectstate	:: !(TimerAttribute .ps) -> Bool
istimerselectstate	(TimerSelectState _)	= True
istimerselectstate	_						= False

istimerfunction		:: !(TimerAttribute .ps) -> Bool
istimerfunction		(TimerFunction _)		= True
istimerfunction		_						= False

gettimerid			:: !(TimerAttribute .ps) -> Id
gettimerid			(TimerId id) = id

gettimerselectstate	:: !(TimerAttribute .ps) -> SelectState
gettimerselectstate	(TimerSelectState s) = s

gettimerfunction	:: !(TimerAttribute .ps) -> TimerFunction .ps
gettimerfunction	(TimerFunction f) = f
